<?php
/**
 * All settings related functions
 */
namespace Codexpert\CoDesigner_Pro\App;
use Codexpert\CoDesigner_Pro\Helper;
use Codexpert\Plugin\Base;
use Codexpert\Plugin\Settings as Settings_API;

/**
 * @package Plugin
 * @subpackage Settings
 * @author Codexpert <hi@codexpert.io>
 */
class Settings extends Base {

	public $plugin;
	public $slug;
	public $name;
	public $version;

	/**
	 * Constructor function
	 */
	public function __construct( $plugin ) {
		$this->plugin	= $plugin;
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->version	= $this->plugin['Version'];
	}

	public function settings_fields( $args ) {
		unset( $args['sections']['codesigner_upgrade'] );

		$email_templates	= Helper::get_posts( [ 'post_type' => 'elementor_library', 'meta_key' => '_elementor_template_type', 'meta_value' => 'wl-email' ] );
		$email_templates	= [ '' => __( 'Use WooCommerce Default', 'codesigner-pro' ) ] + $email_templates;
		$add_new_url		= add_query_arg( [ 'post_type' => 'elementor_library', 'tabs_group' => 'library', 'elementor_library_type' => 'wl-email' ], admin_url( 'edit.php' ) );

		$args['sections']['codesigner_license'] = array(
			'id'        => 'codesigner_license',
			'label'     => __( 'License', 'codesigner-pro' ),
			'icon'      => 'dashicons-admin-network',
			'hide_form'	=> true,
			'content'   => $this->plugin['license']->activator_form(),
		);

		return $args;
	}

	public function pro_settings_fields( $args ) {
		unset( $args['sections']['codesigner_upgrade'] );

		$args['sections']['wcd_license'] = array(
			'id'        => 'wcd_license',
			'label'     => __( 'License', 'codesigner-pro' ),
			'icon'      => 'dashicons-admin-network',
			'color'		=> '#ec5ca7',
			'hide_form'	=> true,
			'content'   => $this->plugin['license']->activator_form(),
		);

		return $args;
	}
}